/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.library;

import com.james.tinkerscalibration.Utils;
import com.james.tinkerscalibration.contents.TinkersCalibrationItems;
import com.james.tinkerscalibration.modifiers.SpaghettiModifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class SpaghettiModifierRecipe
implements ITinkerStationRecipe,
IDisplayModifierRecipe {
    public static final RecordLoadable<SpaghettiModifierRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("ingredient", r -> r.ingredient), (RecordField)IntLoadable.FROM_ONE.requiredField("restore_amount", r -> r.restoreAmount), SpaghettiModifierRecipe::new);
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final int restoreAmount;
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "spaghetti");
    private static final ModifierEntry RESULT = new ModifierEntry(Utils.spaghetti, 1);
    private List<ItemStack> toolWithoutModifier;
    private List<ItemStack> toolWithModifier = null;

    public SpaghettiModifierRecipe(ResourceLocation id, Ingredient ingredient, int restoreAmount) {
        this.id = id;
        this.ingredient = ingredient;
        this.restoreAmount = restoreAmount;
        ModifierRecipeLookup.addRecipeModifier(null, Utils.spaghetti);
    }

    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (!inv.getTinkerableStack().m_150930_((Item)TinkersCalibrationItems.SPAGHETTI.get())) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient((ITinkerableContainer)inv, (Ingredient)this.ingredient);
    }

    public RecipeResult<ItemStack> getValidatedResult(ITinkerStationContainer inv) {
        ToolStack tool = inv.getTinkerable();
        SpaghettiModifier spaghetti = (SpaghettiModifier)Utils.spaghetti.get();
        ModifierId spaghettiId = Utils.spaghetti.getId();
        ModifierEntry entry = tool.getModifier(spaghettiId);
        if (tool.getModifiers().getLevel(spaghettiId) <= 0) {
            return RecipeResult.pass();
        }
        tool = tool.copy();
        int available = IncrementalModifierRecipe.getAvailableAmount((ITinkerStationContainer)inv, (Ingredient)this.ingredient, (int)this.restoreAmount);
        if (available > 640 && available < 1000 && entry.getLevel() == 1) {
            tool.addModifier(spaghettiId, 1);
            tool.addModifier(Utils.spaghetti2.getId(), 1);
            tool.getPersistentData().putInt(this.KEY, 100);
        } else if (available >= 1000 && entry.getLevel() == 2) {
            tool.addModifier(spaghettiId, 1);
            tool.addModifier(Utils.spaghetti3.getId(), 1);
            tool.getPersistentData().putInt(this.KEY, 100);
        } else {
            if (available > 640 && available < 1000 && entry.getLevel() == 2) {
                return RecipeResult.pass();
            }
            if (available >= 1000 && entry.getLevel() == 3) {
                return RecipeResult.pass();
            }
            if (available > 640 && available < 1000 && entry.getLevel() == 3) {
                return RecipeResult.pass();
            }
            if (entry.getLevel() > 0 && spaghetti.getUses((IToolStackView)tool) >= 100) {
                return RecipeResult.pass();
            }
            tool.getPersistentData().putInt(this.KEY, Math.min(available + spaghetti.getUses((IToolStackView)tool), 100));
        }
        return RecipeResult.success((Object)tool.createStack(Math.min(inv.getTinkerableStack().m_41613_(), this.shrinkToolSlotBy())));
    }

    public void updateInputs(ItemStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        ToolStack tool = inv.getTinkerable();
        int current = 0;
        SpaghettiModifier spaghetti = (SpaghettiModifier)Utils.spaghetti.get();
        if (tool.getModifierLevel((Modifier)spaghetti) != 0) {
            current = spaghetti.getUses((IToolStackView)tool);
        }
        if (ToolStack.from((ItemStack)result).getModifierLevel(spaghetti.getId()) > tool.getModifierLevel((Modifier)spaghetti)) {
            IncrementalModifierRecipe.updateInputs((IMutableTinkerStationContainer)inv, (Ingredient)this.ingredient, (int)1, (int)this.restoreAmount, (ItemStack)ItemStack.f_41583_);
        }
        int maxNeeded = spaghetti.getUses((IToolStackView)ToolStack.from((ItemStack)result)) - current;
        IncrementalModifierRecipe.updateInputs((IMutableTinkerStationContainer)inv, (Ingredient)this.ingredient, (int)maxNeeded, (int)this.restoreAmount, (ItemStack)ItemStack.f_41583_);
    }

    @Deprecated
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Utils.spaghettiSerializer.get();
    }

    public int getInputCount() {
        return 1;
    }

    public List<ItemStack> getDisplayItems(int slot) {
        if (slot == 0) {
            return Arrays.asList(this.ingredient.m_43908_());
        }
        return Collections.emptyList();
    }

    public List<ItemStack> getToolWithoutModifier() {
        if (this.toolWithoutModifier == null) {
            this.toolWithoutModifier = RegistryHelper.getTagValueStream((Registry)Registry.f_122827_, (TagKey)TinkerTags.Items.DURABILITY).map(MAP_TOOL_FOR_RENDERING).toList();
        }
        return this.toolWithoutModifier;
    }

    public List<ItemStack> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            List<ModifierEntry> result = List.of(RESULT);
            this.toolWithModifier = RegistryHelper.getTagValueStream((Registry)Registry.f_122827_, (TagKey)TinkerTags.Items.DURABILITY).map(MAP_TOOL_FOR_RENDERING).map(stack -> IDisplayModifierRecipe.withModifiers((ItemStack)stack, (List)result, data -> data.putInt(this.KEY, this.restoreAmount))).toList();
        }
        return this.toolWithModifier;
    }

    public ModifierEntry getDisplayResult() {
        return RESULT;
    }
}

